<div class="max-w-xl mx-auto mt-10 p-6 bg-white rounded-lg shadow-md border border-zinc-200">
    <!-- Add Carrier Form -->
    <form wire:submit.prevent="addCarrier" class="space-y-4">
        <div>
            <label for="carrier_info_code" class="block text-sm font-medium text-black mb-1">Carrier Code</label>
            <input type="text" id="carrier_info_code" wire:model="carrier_info_code"
                class="w-full px-3 py-2 border border-zinc-300 rounded-md focus:outline-none focus:ring-2 focus:ring-accent focus:border-accent text-black" />
            @error('carrier_info_code') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
        </div>
        <div>
            <label for="carrier_info_display_name" class="block text-sm font-medium text-black mb-1">Carrier Display Name</label>
            <input type="text" id="carrier_info_display_name" wire:model="carrier_info_display_name"
                class="w-full px-3 py-2 border border-zinc-300 rounded-md focus:outline-none focus:ring-2 focus:ring-accent focus:border-accent text-black" />
            @error('carrier_info_display_name') <span class="text-red-500 text-xs mt-1 block">{{ $message }}</span> @enderror
        </div>
        <button type="submit"
            class="w-full bg-accent text-black font-semibold py-2 px-4 rounded-md hover:bg-accent-700 transition-colors">Add Carrier</button>
    </form>

    <!-- List of Added Carriers -->
    <h3 class="mt-8 mb-3 text-lg font-bold text-black">Added Carriers</h3>
    <ul class="divide-y divide-zinc-200">
        @forelse($carriers as $carrier)
            <li class="py-3 flex items-center justify-between">
                <div>
                    <span class="font-mono text-black">{{ $carrier->carrier_info_code }}</span>
                    <span class="ml-2 text-black">— {{ $carrier->carrier_info_display_name }}</span>
                </div>
            </li>
        @empty
            <li class="py-3 text-black">No carriers added yet.</li>
        @endforelse
    </ul>
</div>
