<div x-data="{ open: @entangle('showDrawer') }" x-show="open" class="fixed inset-0 z-50 flex justify-end">
    <div class="fixed inset-0 bg-black bg-opacity-40" @click="open = false; $wire.closeDrawer()"></div>
    <div class="relative w-full max-w-md h-full bg-white shadow-xl p-6 overflow-y-auto">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-xl font-bold">Attach Products to Rate</h2>
            <button @click="open = false; $wire.closeDrawer()" class="text-2xl font-bold">&times;</button>
        </div>
        <div class="mb-4 flex gap-2">
            <select wire:model="filterBy" class="border rounded px-2 py-1">
                <option value="name">Name</option>
                <option value="sku">SKU</option>
                <option value="product_id">Product ID</option>
            </select>
            <input type="text" wire:model.debounce.500ms="search" placeholder="Search..." class="border rounded px-2 py-1 flex-1" />
        </div>
        <div class="mb-4">
            <h3 class="font-semibold mb-2">Available Products</h3>
            <ul>
                @forelse($products as $product)
                    <li class="flex items-center justify-between border-b py-2">
                        <div>
                            <div class="font-bold">{{ $product->name }}</div>
                            <div class="text-xs text-gray-500">SKU: {{ $product->sku }} | ID: {{ $product->product_id }}</div>
                        </div>
                        <button wire:click="attachProduct({{ $product->id }})" class="bg-accent text-white px-3 py-1 rounded hover:bg-accent-700">Attach</button>
                    </li>
                @empty
                    <li class="text-gray-400">No products found.</li>
                @endforelse
            </ul>
            <div class="mt-2">{{ $products->links() }}</div>
        </div>
        <div>
            <h3 class="font-semibold mb-2">Attached Products</h3>
            <ul>
                @forelse($attachedProducts as $product)
                    <li class="flex items-center justify-between border-b py-2">
                        <div>
                            <div class="font-bold">{{ $product->name }}</div>
                            <div class="text-xs text-gray-500">SKU: {{ $product->sku }} | ID: {{ $product->product_id }}</div>
                        </div>
                        <button wire:click="detachProduct({{ $product->id }})" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-700">Remove</button>
                    </li>
                @empty
                    <li class="text-gray-400">No products attached.</li>
                @endforelse
            </ul>
            <div class="mt-2">{{ $attachedProducts->links('pagination::tailwind') }}</div>
        </div>
    </div>
</div>
