<div x-data="{ open: @entangle('showDrawer') }"
     x-show="open"
     class="fixed inset-0 z-50 flex justify-end dark:bg-black dark:bg-opacity-40">

{{-- Overlay --}}
    <div class="fixed inset-0 bg-black bg-opacity-40 dark:bg-opacity-60" @click="open = false; $wire.closeDrawer()"></div>

    {{-- Drawer --}}
    <div
        class="absolute h-full mr-[240px] w-[calc(100%-340px)] max-w-[calc(100%-240px)]
           sm:max-w-3xl lg:max-w-5xl xl:max-w-[1150px]
           bg-white dark:bg-neutral-900 text-black dark:text-white
           border border-gray-300 dark:border-neutral-700
           shadow-2xl rounded-md p-6 overflow-y-auto
           transition-all duration-300">
        <div class="flex items-center justify-between mb-6 text-black" >
            <h2 class="text-2xl font-bold">Attach Products to Rate</h2>
            <button @click="open = false; $wire.closeDrawer()" class="text-2xl font-bold hover:text-red-500 dark:hover:text-red-400">&times;</button>
        </div>

        <div class="flex gap-6 text-black">
            {{-- Left: Attached Products --}}
            <div class="w-[45%] pr-4">
                <h3 class="text-lg font-semibold mb-2 text-black dark:text-black">Attached Products</h3>

                <div class="overflow-x-auto text-black">
                    <table class="table-fixed h-full w-full border border-gray-300 dark:border-neutral-700 rounded text-black">
                        <thead class="bg-gray-100 dark:bg-neutral-800 text-black dark:text-black text-sm font-semibold uppercase">
                            <tr>
                                <th class="px-4 py-3 text-left w-[20px]">SKU</th>
                                <th class="px-4 py-3 text-left w-[80px]">Product Name</th>
                                <th class="px-4 py-3 text-left w-[40px]">Product ID</th>
                                <th class="px-4 py-3 text-left w-[80px]">Action</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm text-black dark:text-black">
                            @forelse($attachedProducts as $product)
                                <tr class="@if($loop->odd) bg-white dark:bg-neutral-900 @else bg-gray-100 dark:bg-neutral-800 @endif hover:bg-gray-100 dark:hover:bg-neutral-700">
                                    <td class="px-4 py-2">{{ $product->sku }}</td>
                                    <td class="px-4 py-2 break-words whitespace-normal max-w-[50px]" >{{ $product->name }}</td>
                                    <td class="px-4 py-2">{{ $product->product_id }}</td>
                                    <td class="px-4 py-2">
                                        <button wire:click="detachProduct({{ $product->id }})" class="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-700">Remove</button>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-4 py-4 text-center text-gray-500 dark:text-neutral-400">No products attached.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-2">{{ $attachedProducts->links() }}</div>
            </div>

            {{-- Divider --}}
            <div class="w-px bg-black dark:bg-neutral-600"></div>

            {{-- Right: Available Products --}}
            <div class="w-[45%] pl-4 text-black">
                <div class="flex gap-2 mb-4">
                    <select wire:model="filterBy"
                            class="border rounded px-2 py-1 bg-white dark:bg-neutral-800 text-black dark:text-black">
                        <option value="name">Name</option>
                        <option value="sku">SKU</option>
                        <option value="product_id">Product ID</option>
                    </select>
                    <input type="text"
                           x-data="{ value: @entangle('search') }"
                           x-model.debounce.200ms="value"
                           @keyup.debounce.200ms="$wire.set('search', value)"
                           placeholder="Search..."
                           class="border rounded px-2 py-1 flex-1 bg-white dark:bg-neutral-800 text-black dark:text-black placeholder-gray-400 dark:placeholder-neutral-500 w-[calc(100%-240px)]" />
                </div>

                <h3 class="text-lg font-semibold mb-2 text-black dark:text-black">Available Products</h3>
                <div class="overflow-x-auto text-black">
                    <table class="table-fixed h-full  w-full border border-gray-300 dark:border-neutral-700 rounded text-black">
                        <thead class="bg-gray-100 dark:bg-neutral-800 text-black dark:text-black text-sm font-semibold uppercase">
                        <tr>
                            <th class="px-4 py-3 text-left w-[20px]">SKU</th>
                            <th class="px-4 py-3 text-left w-[80px]">Product Name</th>
                            <th class="px-4 py-3 text-left w-[40px]">Product ID</th>
                            <th class="px-4 py-3 text-left w-[80px]">Action</th>
                        </tr>
                        </thead>
                        <tbody class="text-sm text-black dark:text-black">
                        @forelse($products as $product)
                            <tr class="@if($loop->odd) bg-white dark:bg-neutral-900 @else bg-gray-100 dark:bg-neutral-800 @endif hover:bg-gray-100 dark:hover:bg-neutral-700">
                                <td class="px-4 py-2">{{ $product->sku }}</td>
                                <td class="px-4 py-2 break-words whitespace-normal max-w-[50px]" >{{ $product->name }}</td>
                                <td class="px-4 py-2">{{ $product->product_id }}</td>
                                <td class="px-4 py-2">
                                    <button wire:click="attachProduct({{ $product->id }})"
                                            class="cursor-pointer bg-accent text-black border border-black px-3 py-1 rounded hover:bg-accent-700 dark:bg-yellow-400 dark:hover:bg-yellow-300">
                                        Attach
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-4 text-center text-gray-500 dark:text-neutral-400">No products found.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-2">{{ $products->links() }}</div>
            </div>
        </div>
    </div>
</div>
