<?php

namespace Mtc\BigCommerceRates\Http\Controllers\BigCommerce\Shipping;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Mtc\BigCommerceRates\Models\BigCommerce\Rates\StoreCarrier;
use Mtc\BigCommerceRates\Models\StoreInstallation;
use Illuminate\Support\Collection;


class CarrierController extends Controller
{
    public function rates(Request $request)
    {
        Log::debug("");
        Log::debug("Request:",$request->toArray());
        Log::debug("");

        /**
         * determine country and return appropriate rates
         */
        $storeHash = $request->input('base_options.store_id');
        $countryCode = $request->input('base_options.destination.country_iso2');

        $cartId = collect($request->input('base_options.request_context.reference_values'))->firstWhere('name', 'cart_id')['value'] ?? null;;

        $checkoutEndpoint =  env('APP_URL')."bc-api/{$storeHash}/v3/checkouts/$cartId";
        $data = [
            'include' => 'cart.line_items.physical_items.options,cart.line_items.digital_items.options,consignments.available_shipping_options'
        ];


        try {
            $response = Http::timeout(400)
                ->connectTimeout(1)
                ->get($checkoutEndpoint,$data)->json();

            $lineItems = data_get($response, 'data.cart.line_items', []);


            $allItems = collect($lineItems)->flatMap(function ($items) {
                return is_array($items) ? $items : [];
            })->values();


        } catch (\Illuminate\Http\Client\HttpClientException $clientException) {
            Log::error("Error: ", $clientException->getMessage());
        }





        $rates = $this->storeRates(
                    storeHash: $storeHash,
                    countryCode: $countryCode,
                    items: $allItems
                );

        Log::debug("");
        Log::debug("");
        Log::debug("Response:",$rates);
        Log::debug("");
        Log::debug("");

        /**
         * return rates
         */
        return response()->json($rates);
    }


    public function storeRates(string $storeHash, string $countryCode, Collection $items)
    {
        /**
         * fetching all carriers with rates and costs for a storeID
         */
        $storeId = StoreInstallation::where('store_hash',$storeHash)->first()->id;
        $allItemsAreFreeSamples = collect($items)->every(function ($item) {
            return collect($item['options'] ?? [])->contains(function ($option) {
                return strtolower($option['name'] ?? '') === 'free sample' && strtolower($option['value'] ?? '') === 'yes';
            });
        });


        $carriers = StoreCarrier::with(['rates.rateCost'])
            ->where('store_id', $storeId)
            ->get();

        $quotes = [
            'quote_id' => uuid_create(UUID_TYPE_TIME),
            'messages' => [],
            'carrier_quotes' => $carriers
                ->filter(function ($carrier) use ($allItemsAreFreeSamples) {
                    $isFreeCarrier = str_contains(strtolower($carrier->carrier_info_display_name), 'free');

                    return $allItemsAreFreeSamples
                        ? $isFreeCarrier     // keep only free if all items are free samples
                        : !$isFreeCarrier;   // remove free if not all items are free samples
                })
                ->map(function ($carrier) {
                    return [
                        'carrier_info' => [
                            'code' => $carrier->carrier_info_code,
                            'display_name' => $carrier->carrier_info_display_name,
                        ],
                        'quotes' => $carrier->rates->map(function ($rate) use ($carrier) {
                            return [
                                'code' => $rate->code,
                                'rate_id' => $rate->rate_id,
                                'display_name' => $rate->display_name,
                                'description' => $carrier->carrier_info_display_name,
                                'cost' => [
                                    'currency' => optional($rate->rateCost)->currency,
                                    'amount' => round(optional($rate->rateCost)->amount, 3),
                                ],
                            ];
                        })->values()->toArray(),
                    ];
                })
                ->values()
                ->toArray()
        ];


       return $quotes;
    }


    protected function emptyRate()
    {
        $emptyRate = [
            "quote_id"=>uuid_create(UUID_TYPE_TIME),
            "messages"=>[],
            "ttl"=>3600,
            "carrier_quotes"=>[]
        ];

        return [
                "quote_id"=>uuid_create(UUID_TYPE_TIME),
                "messages"=>[],
                "ttl"=>3600,
            "carrier_quotes"=>[]
        ];

    }


    public function validateConnection(Request $request)
    {
        return response()->json([
            'valid' => true,
            'messages' => [],
        ]);
    }
}
