<?php


    namespace Mtc\BigCommerceRates\Http\Middleware;

    use Mtc\BigCommerceRates\Models\StoreInstallation;
    use Closure;
    use Mtc\BigCommerceRates\Models\User;
    use Tymon\JWTAuth\Exceptions\JWTException;
    use Tymon\JWTAuth\Exceptions\TokenExpiredException;
    use Tymon\JWTAuth\Facades\JWTAuth;
    use Exception;
    use Illuminate\Support\Facades\Log;
    use Illuminate\Support\Str;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\Facades\Cookie;
    use Firebase\JWT\JWT;
    use Firebase\JWT\Key;

    class JwtAuthenticate
    {
        public const ALIAS = 'bc.jwt';
        /**
         * Handle an incoming request.
         *
         * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
         */
        public function handle($request, Closure $next)
        {
            debug(request()->all());
            try {
                $token = $request->bearerToken() ?? $request->query('token');

                // Attempt to identify store hash (from query, subdomain, or token payload later)
                $storeHash = $request->query('store_hash');
                debug($storeHash);

                if (!$token) {
                    foreach ($request->cookies as $cookieName => $cookieValue) {
                        if (Str::startsWith($cookieName, 'bc_jwt_')) {
                            $token = $cookieValue;
                            // Extract store_hash from cookie name
                            $storeHash = substr($cookieName, strlen('bc_jwt_'));
                            Log::info('Found JWT cookie', ['cookie_name' => $cookieName, 'store_hash' => $storeHash]);
                            break;
                        }
                    }
                }

                $needsNewToken = false;

                if ($token) {
                    try {
                        if (!JWTAuth::setToken($token)->check()) {
                            $needsNewToken = true;
                        }
                    } catch (TokenExpiredException | JWTException $e) {
                        $needsNewToken = true;
                    }
                } else {
                    $needsNewToken = true;
                }

                if($needsNewToken){
                    $signedPayload = request()->input('signed_payload_jwt');
                    $decoded = JWT::decode($signedPayload, new Key(env('BIGCOMMERCE_APP_CLIENT_SECRET'), 'HS256'));


                    if (!$storeHash) {

                        $storeHash = str_replace('stores/', '', $decoded->sub);
                    }
                    $user = User::where("store_id",StoreInstallation::findByStoreHash($storeHash)->id)->first();
                    $token = JWTAuth::claims(['exp' => now()->addHour()->timestamp])->fromUser($user);
                    $cookieName = 'bc_jwt_' . $storeHash;
                    $domain = env('SESSION_DOMAIN', null);
                    Cookie::forget($cookieName,'/',$domain);
                    Log::info('Generated new token', ['token' => $token]);
                    $cookie = Cookie::make($cookieName, $token, 60 * 24, '/', $domain, true, true, false, 'None');
                    $response = $next($request);
                    return $response->withCookie($cookie);

                }else{
                    if ($token) {
                        Log::info('Received token', ['token' => $token]);

                        // Authenticate using tymon/jwt-auth
                        $user = JWTAuth::setToken($token)->authenticate();

                        if (!$user) {
                            throw new Exception('Invalid token: user not found');
                        }

//                    Auth::login($user);

                        // Retrieve store hash from payload if not already provided
                        if (!$storeHash) {

                            $payload = JWTAuth::setToken($token)->getPayload();
                            $storeHash = str_replace('stores/', '', $payload->get('sub', ''));
                            Log::info('Extracted store hash from JWT', ['store_hash' => $storeHash]);
                        }

                        if ($storeHash) {
                            $cookieName = 'bc_jwt_' . $storeHash;

                            // Set cookie if not already present
                            if (($request->has('token') || $request->bearerToken()) && !$request->hasCookie($cookieName)) {
                                $domain = env('SESSION_DOMAIN', null);
                                $cookie = Cookie::make($cookieName, $token, 60 * 24, '/', $domain, true, true, false, 'None');
                                Log::info('Setting store-specific cookie', ['cookie_name' => $cookieName]);

                                // Attach the cookie to the response, but do NOT redirect
                                $response = $next($request);
                                return $response->withCookie($cookie);
                            }
                        }
                    }
                }



            } catch (Exception $e) {
                Log::error('JWT Auth Exception', ['message' => $e->getMessage()]);
                return response()->json(['error' => 'Unauthorized'], 401);
            }

            return $next($request);
        }
    }
