<?php
namespace Mtc\BigCommerceRates\Providers\BigCommerce;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\BigCommerceRates\Console\Commands\ImportProducts;
use Livewire\Livewire;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\View;
use Mtc\BigCommerceRates\Http\Middleware\JwtAuthenticate;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Http\Middleware\HandleCors;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Carrier;
use Mtc\BigCommerceRates\Livewire\BigCommerce\Product\Import as ProductImport;
use Illuminate\Contracts\Http\Kernel;
use ReflectionClass;
use Symfony\Component\Finder\Finder;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Log;


class Resources extends ServiceProvider
{
    /**
     *  register method is for binding a singleton or registering a config merge
     */
	public function register()
	{
        $loader = \Illuminate\Foundation\AliasLoader::getInstance();
        $loader->alias('Debugbar', \Barryvdh\Debugbar\Facades\Debugbar::class);
	}


    /**
     *
     * Boot method is for publishing migration files, registering routes midldeware and views/translations
     *
     * */
    public function boot()
    {


        // Register middleware early
        $this->registerMiddlewareAliases();
        $this->registerGlobalMiddleware();
        $this->excludeCsrfRoutes();



        //Publish Database assets
        $this->publishes([
            __DIR__.'/../../../database/migrations/' => database_path('migrations'),
            // __DIR__.'/../../../database/seeders/' => database_path('seeders')

        ],"database");

        $this->loadViewsFrom(__DIR__.'/../../../resources/views', 'bigcommerce');

        // Register all Livewire components in the package
        $this->registerLivewireComponentsFrom(
            __DIR__ . '/../../Livewire',
            'Mtc\\BigCommerceRates\\Livewire'
        );


/*        $reflect = new \ReflectionClass(app(\Livewire\Mechanisms\ComponentRegistry::class));
        $prop = $reflect->getProperty('aliases');
        $prop->setAccessible(true);
        dump($prop->getValue(app(\Livewire\Mechanisms\ComponentRegistry::class)));*/



        $this->loadMenus();


        // Register console commands only when running in the console
        if ($this->app->runningInConsole()) {
            $this->commands([
                ImportProducts::class,
            ]);
        }

    }


    public function registerMiddlewareAliases()
    {
            $router = $this->app->make(Router::class);
            $middlewarePath = __DIR__ . '/../../Http/Middleware';
            $middlewareNamespace = 'Mtc\\BigCommerceRates\\Http\\Middleware';

            foreach ((new Finder)->files()->in($middlewarePath)->name('*.php') as $file) {
                $className = $middlewareNamespace . '\\' . $file->getBasename('.php');
                if (!class_exists($className)) {
                    require_once $file->getRealPath(); // in case it's not autoloaded
                }

                if (!class_exists($className)) continue;
                $reflection = new ReflectionClass($className);

                // Skip abstract or non-instantiable classes
                if (! $reflection->isInstantiable()) continue;

                // Require a handle() method to be treated as middleware
                if (! $reflection->hasMethod('handle')) continue;

                // Determine alias: use ALIAS constant if present, else fallback to kebab-case class name
                $alias = $reflection->hasConstant('ALIAS')
                    ? $reflection->getConstant('ALIAS')
                    : Str::kebab(class_basename($className));

                Log::debug("loading: {$alias} for {$className}");
                $router->aliasMiddleware($alias, $className);

            }

    }

    protected function registerGlobalMiddleware(): void
    {
        $this->app->booted(function () {
            /** @var Kernel $kernel */
            $kernel = $this->app->make(Kernel::class);

            // If you want to add CORS early in the stack
            $kernel->prependMiddleware(HandleCors::class);

            if(config('app.debug')){
                $kernel->pushMiddleware(\Mtc\BigCommerceRates\Http\Middleware\DebugRequestMiddleware::class);
            }

        });
    }

    protected function excludeCsrfRoutes(): void
    {
        $this->app->resolving(VerifyCsrfToken::class, function ($middleware) {
            $reflector = new \ReflectionClass($middleware);
            if ($reflector->hasProperty('except')) {
                $property = $reflector->getProperty('except');
                $property->setAccessible(true);
                $existing = $property->getValue($middleware);
                $property->setValue($middleware, array_merge((array) $existing, [
                    'api/*',
                    'bc-api/*',
                    'auth/*',
                    'biginstall/*',
                    'livewire/*',
                ]));
            }
        });
    }


    protected function registerLivewireComponentsFrom($directory, $namespace, $aliasPrefix = 'bigcommerce.')
    {
        $baseNamespace = 'Mtc\\BigCommerceRates\\Livewire\\';

        foreach (glob($directory . '/*.php') as $file) {
            $class = $namespace . '\\' . pathinfo($file, PATHINFO_FILENAME);

            if (!class_exists($class)) {
                require_once $file;
            }

            if (!is_subclass_of($class, \Livewire\Component::class)) {
                continue;
            }

            // Get namespace relative to base, e.g., "BigCommerce\Rates\ProductRateAttachment"
            $relative = Str::after($class, $baseNamespace);

            // Convert to alias: BigCommerce\Rates\ProductRateAttachment => bigcommerce.rates.product-rate-attachment
            $alias = $aliasPrefix . collect(explode('\\', $relative))
                    ->map(fn ($part) => Str::kebab($part))
                    ->implode('.');

            \Livewire\Livewire::component($alias, $class);
        }

        // Recursively register subdirectories
        foreach (glob($directory . '/*', GLOB_ONLYDIR) as $subdir) {
            $subNamespace = $namespace . '\\' . basename($subdir);
            $this->registerLivewireComponentsFrom($subdir, $subNamespace, $aliasPrefix);
        }
    }


    public function loadMenus()
    {
        View::composer('components.layouts.app.sidebar', function ($view) {
                $menus = $view->sidebarExtraMenus ?? [];
                $menus[] = view('bigcommerce::sidebar.extra-menus')->render();
                $view->with('sidebarExtraMenus', $menus);
            });
    }
}
