<?php

namespace Mtc\BigCommerceRates\Providers\BigCommerce;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\BigCommerceRates\Http\Middleware\JwtAuthenticate;
use Illuminate\Routing\Router;


class RouteServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->mapApiRoutes();
        $this->mapBigCRoutes();
        $this->mapWebhookRoutes();
        $this->mapBigCWebRoutes();
    }



    protected function mapBigCRoutes()
    {
        Route::prefix('biginstall')
            ->withoutMiddleware(['auth'])
            ->middleware(['api','bc.jwt','web'])
            ->group(__DIR__ . '/../../../routes/bigcommerce.php');
    }

    protected function mapApiRoutes()
    {
        // bc-api routes
        Route::prefix('bc-api')
            ->withoutMiddleware(['bc.jwt'])
            ->middleware('api')
            ->group(__DIR__ . '/../../../routes/api-bigcommerce.php');
    }

    protected function mapBigCWebRoutes()
    {
        Route::middleware(['web', 'bc.jwt','auth'])
            ->group(__DIR__ . '/../../../routes/web-bigcommerce.php');
    }

    protected function mapWebhookRoutes(){
        // webhook routes
        Route::prefix('webhook')
            ->middleware('api')
            ->group(__DIR__ . '/../../../routes/webhook.php'); // Assuming webhook routes are in routes/webhook.php
    }

}
