<?php

namespace Mtc\BitPay\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Mtc\BitPay\BitPay;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

class BitPayController
{
    /**
     * Handle IPN
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @param BitPay $gateway
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function handle(Request $request, InvoiceRepositoryContract $invoice, BitPay $gateway)
    {
        Log::debug('bitpay notification ', $request->input());
        if ($request->input('id') === $invoice->getModel()->details['bitpay_invoice_id'] ?? '') {
            $payment_data = $gateway->charge($request, $invoice);
            if (empty($payment_data)) {
                return response('Transaction not found', 422);
            }

            $invoice->savePayment($payment_data);
            return response('Payment processed');
        }
        return response('Transaction not found', 422);
    }
}
