<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Mtc\Blog\ArticleStatus;

class CreateBlogTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blog_articles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('segment', 30)->index();
            $table->string('url_slug')->index();
            $table->string('status')->default(ArticleStatus::DRAFT);
            $table->dateTime('published_at')->index()->nullable();
            $table->string('title')->index();
            $table->unsignedBigInteger('author_id')->index();
            $table->boolean('is_featured')->index();
            $table->string('image')->nullable();
            $table->text('excerpt')->nullable();
            $table->text('search_content')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->unique([
                'segment',
                'url_slug',
            ], 'unique_url_index');
        });

        Schema::create('blog_article_taxonomies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('article_id');
            $table->unsignedBigInteger('taxonomy_id');
            $table->string('type')->index();
            $table->timestamps();

            $table->index([
                'article_id',
                'taxonomy_id'
            ], 'article_taxonomies');
        });

        Schema::create('blog_article_versions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('revision');
            $table->unsignedBigInteger('article_id')->index();
            $table->boolean('is_active')->default(0);
            $table->string('status', 30)->nullable()->index();
            $table->boolean('pending_review')->default(0)->index();
            $table->string('title')->nullable()->index();
            $table->text('content')->nullable();
            $table->text('excerpt')->nullable();
            $table->timestamps();

            $table->index([
                'article_id',
                'is_active'
            ], 'article_active_version');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blog_articles');
        Schema::dropIfExists('blog_article_taxonomies');
        Schema::dropIfExists('blog_article_versions');
    }
}
