<?php


use Illuminate\Routing\Router;
use Mtc\Blog\Http\Controllers\Admin\BlogController as AdminBlogController;
use Mtc\Blog\Http\Controllers\BlogController as PublicBlogController;

/** @var Router $router */

collect(config('blog.segments', []))
    ->each(function ($section, $url) use ($router) {

        $router->group([
            'prefix' => '/admin',
            'as' => 'admin.',
            'middleware' => ['auth']
        ], function (Router $router) use ($url) {
            $router->resource($url, AdminBlogController::class)->parameter($url, 'article');
        });


        $router->get($url, [ PublicBlogController::class, 'index' ])->name("{$url}.index");
        $router->get("{$url}/{blog_article}", [ PublicBlogController::class, 'show' ])->name("{$url}.show");
    });
