<?php

namespace Mtc\Blog;

use Illuminate\Database\Eloquent\Model;

/**
 * Class ArticleVersion
 *
 * @package Mtc\Blog
 */
class ArticleVersion extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'blog_article_versions';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'is_active',
        'status',
        'pending_review',
        'title',
        'content',
        'excerpt',
    ];

    /**
     * Cast to specific types
     *
     * @var array
     */
    protected $casts = [
       'is_active' => 'boolean',
       'pending_review' => 'boolean',
    ];

    /**
     * Touch related model on update
     *
     * @var array
     */
    protected $touches = [
        'article'
    ];

    /**
     * Boot model
     */
    protected static function boot()
    {
        parent::boot();

        self::creating(function (self $version) {
            $version->revision = $version->getUpcomingRevisionNumber() + 1;
        });
    }

    /**
     * Article
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function article()
    {
        return $this->belongsTo(Article::class, 'article_id');
    }

    /**
     * Get the name of the status
     *
     * @return mixed
     */
    public function getStatusNameAttribute()
    {
        return ArticleVersionStatus::$statuses[$this->status];
    }

    /**
     * Find the revision number for the version
     *
     * @return int|mixed
     */
    protected function getUpcomingRevisionNumber()
    {
        return self::query()
            ->where('article_id', $this->article_id)
            ->latest('revision')
            ->first()
            ->revision ?? 0;
    }
}
