<?php

namespace Mtc\Blog;

use Mtc\Blog\Providers\ContentProvider;
use Mtc\Foundation\Contracts\InstallableComponent;
use Mtc\Blog\Providers\TaxonomyServiceProvider;

/**
 * Class TaxonomyInstaller
 *
 * @package Mtc\Blog
 */
class BlogInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => ContentProvider::class,
                '--tag' => 'assets'
            ]
        ];
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     */
    public function seed(): string
    {
        return '';
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        return [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}
