<?php

namespace Mtc\Blog\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\Blog\Article;

/**
 * Class ClearBlogTrash
 *
 * @package Mtc\Blog\Console\Commands
 */
class ClearBlogTrash extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'blog:clear-trash';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove trashed articles after they have expired';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        Article::query()
            ->trashed()
            ->where('deleted_at', '<=', Carbon::now()->subDays(config('blog.trashed_lifetime_days')))
            ->forceDelete();
    }
}
