<?php

namespace Mtc\Blog\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Blog\Article;
use Mtc\Blog\ArticleVersionStatus;
use Mtc\Blog\Http\Requests\ArticleAdminRequest;
use Mtc\Blog\Http\Requests\SaveArticleRequest;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return string
     */
    public function index(ArticleAdminRequest $request)
    {
        return template('admin/blog/index.twig', [
            'segment' => $request->getSegment(),
            'segment_data' => config("blog.segments.{$request->getSegment()}")
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return string
     */
    public function create(ArticleAdminRequest $request)
    {
        return template('admin/blog/edit.twig', [
            'form_action' => route("admin.{$request->getSegment()}.store"),
            'segment' => $request->getSegment(),
            'authors' => $request->getAuthors(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Http\RedirectResponse
     */
    public function store(SaveArticleRequest $request, Article $article)
    {
        $article->fill([
            'segment' => $request->getSegment(),
            'title' => $request->input('title'),
            'published_at' => $request->input('published_at'),
            'author_id' => $request->input('author_id'),
        ]);
        $article->save();

        $article->versions()
            ->create([
                'is_active' => 1,
                'status' => ArticleVersionStatus::ACTIVE,
                'content' => $request->input('content'),
            ]);

        if ($request->wantsJson()) {
            return [
                'status' => 'ok',
                'message' => 'Content Saved',
            ];
        }
        session()->flash('success', 'Content Saved');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return string
     */
    public function edit(ArticleAdminRequest $request, Article $article)
    {
        return template('admin/blog/edit.twig', [
            'article' => $article,
            'segment' => $request->getSegment(),
            'form_action' => route("admin.{$request->getSegment()}.update", [ $article->url_slug ]),
            'authors' => $request->getAuthors(),
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return array|\Illuminate\Http\RedirectResponse
     */
    public function update(SaveArticleRequest $request, Article $article)
    {
        // TODO: figure out if changes need to be made, if version should be crated or updated
        $article->versions()
            ->create([
                'is_active' => (bool)$request->input('make_active'),
                'status' => $request->input('make_active') ? ArticleVersionStatus::ACTIVE : ArticleVersionStatus::DRAFT,
                'title' => $request->input('title'),
                'content' => $request->input('content'),
            ]);

        if ($request->wantsJson()) {
            return [
                'status' => 'ok',
                'message' => 'Content Saved',
            ];
        }
        session()->flash('success', 'Content Saved');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
