<?php

namespace Mtc\Blog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Core\Admin\User;

/**
 * Class ArticleAdminRequest
 *
 * @package Mtc\Blog\Http\Requests
 */
class ArticleAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
        ];
    }

    /**
     * Get the segment for
     *
     * @return mixed|null
     */
    public function getSegment()
    {
        $segments = $this->segments();
        return $segments[1] ?? null;
    }

    /**
     * Get the author list
     *
     * @return \Illuminate\Support\Collection
     */
    public function getAuthors()
    {
        // TODO: Add permission for editing content
        return User::query()
            ->pluck('name', 'id');
    }
}
