<?php

namespace Mtc\Blog\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Blog\Article;

/**
 * Class ArticleRequest
 *
 * @package Mtc\Blog\Http\Requests
 */
class ArticleRequest extends FormRequest
{
    /**
     * @var Article
     */
    public $article;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->article->exists;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            //
        ];
    }

    /**
     * Get template path
     *
     * @param null $custom_template
     * @return \Illuminate\Config\Repository|mixed|null
     */
    public function getTemplate($custom_template = null)
    {
        return $custom_template ?? config("blog.segments.{$this->article->segment}.template");
    }

    /**
     * Prepare data
     */
    protected function prepareForValidation()
    {
        $this->findArticle();
    }

    /**
     * Find the article for request
     */
    protected function findArticle()
    {
        $segments = $this->segments();
        $this->article = Article::query()
            ->with('activeVersion')
            ->where('segment', $segments[0])
            ->where('url_slug', $segments[1])
            ->firstOrNew([]);
    }

}
