<?php

namespace Mtc\Blog\Providers;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\Blog\Console\Commands\ClearBlogTrash;

/**
 * Class ContentProvider
 *
 * @package Mtc\Blog\Providers
 */
class ContentProvider extends ServiceProvider
{
    /**
     * Register service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/blog.php', 'blog');
    }

    /**
     * Boot Service
     */
    public function boot()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'blog');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');


        if ($this->app->runningInConsole()) {
            $this->scheduleTasks();
            $this->publish();
            $this->commands([
                ClearBlogTrash::class
            ]);
        }
    }

    /**
     * Publish functionality
     */
    public function publish()
    {
        $this->publishes([
            dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            dirname(__DIR__, 2) . '/resources/less' => resource_path('less/vendor')
        ], 'assets');
    }

    /**
     * Schedule cron tasks
     */
    protected function scheduleTasks()
    {
        $this->app->booted(function () {
            $schedule = $this->app->make(Schedule::class);
            $schedule->command(ClearBlogTrash::class)->daily();
        });
    }
}