<?php

namespace Mtc\Blog\Scopes;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Mtc\Blog\ArticleStatus;

/**
 * Class ViewableArticle
 *
 * @package Mtc\Blog\Scopes
 */
class ViewableArticle implements Scope
{
    /**
     * Apply scope
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->where('published_at', '<=', Carbon::now())
            ->where('status', ArticleStatus::ACTIVE);
    }
}
