<?php

namespace Mtc\Blog\Traits;

use Illuminate\Support\Str;
use Mtc\Blog\Exceptions\UrlAlreadyExists;

/**
 * Trait HasUrl
 *
 * @package Mtc\Blog\Traits
 */
trait HasUrl
{

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'url_slug';
    }

    /**
     * Generate url slug based
     *
     * @param null $url_slug
     * @throws UrlAlreadyExists
     */
    public function generateSlug($url_slug = null, $slug_attribute = 'title')
    {
        if (!empty($url_slug)) {
            $this->url_slug = Str::slug($url_slug);
        } elseif (empty($this->url_slug)) {
            $this->url_slug = Str::slug($this->attributes[$slug_attribute]);
        }

        if ($this->slugExists($this->segment, $this->url_slug)) {
            throw new UrlAlreadyExists();
        }
    }

    /**
     * Check if url slug exists
     *
     * @param $segment
     * @param $url_slug
     * @return mixed
     */
    public function slugExists($segment, $url_slug)
    {
        return self::query()
            ->where('segment', $segment)
            ->where('url_slug', $url_slug)
            ->exists();
    }

    /**
     * Get the public url
     * @return string
     */
    public function getUrlAttribute()
    {
        if (!empty ($this->url_slug)) {
            return route("{$this->segment}.show", [$this->url_slug]);
        }

        return '';
    }
}