<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExVatColumnsToInvoices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('amount_ex_vat', 10)->after('amount')->nullable();
            $table->decimal('outstanding_amount_ex_vat', 10)->after('outstanding_amount')->nullable();
            $table->boolean('use_ex_vat')->default(0)->after('vat_value');
            $table->decimal('outstanding_amount', 10)->nullable()->change();
            $table->decimal('amount', 10)->nullable()->change();
        });

        Schema::table('invoice_items', function (Blueprint $table) {
            $table->decimal('value_ex_vat', 10)->after('value')->nullable();
            $table->decimal('original_value_ex_vat', 10)->after('original_value')->nullable();
            $table->decimal('line_total_ex_vat', 10)->after('line_total')->nullable();
            $table->decimal('value', 10)->nullable()->change();
            $table->decimal('original_value', 10)->nullable()->change();
            $table->decimal('line_total', 10)->nullable()->change();
        });
        Schema::table('invoice_lines', function (Blueprint $table) {
            $table->decimal('value_ex_vat', 10)->after('value')->nullable();
            $table->decimal('value', 10)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn('amount_ex_vat');
            $table->dropColumn('outstanding_amount_ex_vat');
            $table->dropColumn('use_ex_vat');
        });

        Schema::table('invoice_items', function (Blueprint $table) {
            $table->dropColumn('value_ex_vat');
            $table->dropColumn('original_value_ex_vat');
            $table->dropColumn('line_total_ex_vat');
        });
        Schema::table('invoice_lines', function (Blueprint $table) {
            $table->dropColumn('value_ex_vat');
        });
    }
}
