<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoiceTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->increments('id');
            $table->morphs('payable');
            $table->string('reference', 100)->index();
            $table->string('email', 100)->index();
            $table->decimal('amount', 10);
            $table->decimal('outstanding_amount', 10)->nullable()->index();
            $table->decimal('vat_value', 10)->nullable();
            $table->text('details')->nullable();
            $table->date('due_at')->nullable();
            $table->string('template')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_items', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('invoice_id')->nullable()->index();
            $table->unsignedInteger('purchasable_id')->nullable();
            $table->string('purchasable_type')->nullable();
            $table->string('name')->nullable();
            $table->decimal('value', 10);
            $table->integer('quantity');
            $table->decimal('line_total', 10);
            $table->string('vat_rate')->nullable();
            $table->text('details')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->index([
                'purchasable_id',
                'purchasable_type',
            ]);
        });

        Schema::create('invoice_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('invoice_id')->nullable()->index();
            $table->string('type', 50)->index();
            $table->string('name');
            $table->boolean('is_negative')->nullable()->index();
            $table->decimal('value', 10);
            $table->timestamps();
        });

        Schema::create('invoice_payments', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('invoice_id')->nullable()->index();
            $table->string('provider', 100)->index();
            $table->decimal('amount', 10);
            $table->string('reference', 100)->index();
            $table->dateTime('confirmed_at')->nullable()->index();
            $table->text('details')->nullable();
            $table->timestamps();
        });

        Schema::create('invoice_addresses', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('invoice_id')->nullable()->index();
            $table->string('type', 20)->index();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('address1')->nullable();
            $table->string('address2')->nullable();
            $table->string('city')->nullable();
            $table->string('county')->nullable();
            $table->string('postcode')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
        Schema::dropIfExists('invoice_items');
        Schema::dropIfExists('invoice_lines');
        Schema::dropIfExists('invoice_payments');
        Schema::dropIfExists('invoice_addresses');
    }
}
