<?php

use Illuminate\Routing\Router;
use Mtc\Checkout\Http\Controllers\PaymentController;
use Mtc\Checkout\Http\Controllers\Admin\InvoiceController;

/** @var Router $router */

$router->get('/payment/', [PaymentController::class, 'show'])->name('view_invoice');
$router->post('/payment/get-options', [PaymentController::class, 'initializePayment']);
$router->post('/payment/{invoice_id}/get-options', [PaymentController::class, 'initializeInvoice']);
$router->get('/payment/{invoice_id}/charge', [PaymentController::class, 'charge']);
$router->post('/payment/{invoice_id}/charge', [PaymentController::class, 'charge'])->name('charge_payment');
$router->get('/payment/success', [PaymentController::class, 'success'])->name('successful_payment');
$router->get('/payment/failed', [PaymentController::class, 'failed'])->name('failed_payment');


$router->group([
    'prefix' => 'admin',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->post('/invoices/{invoice}/{payment}/charge', [PaymentController::class, 'deferredCharge'])->name('invoice.deferred-charge');
    $router->post('invoices/{invoice_id}/print', [InvoiceController::class, 'print'])->name('invoice.print');
    $router->get('invoices/{invoice}/split', [InvoiceController::class, 'splitView'])->name('invoice.split');
    $router->put('invoices/{invoice}/split-invoice', [InvoiceController::class, 'split'])->name('invoice.split-invoice');
    $router->post('invoices/{invoice_id}/note', [InvoiceController::class, 'saveNote'])->name('invoice.save-note');
    $router->post('invoices/{invoice_id}/invite-to-pay', [InvoiceController::class, 'invite'])->name('invoice.invite-to-pay');
    $router->post('invoices/{invoice}/mark-paid-manually', [InvoiceController::class, 'confirmManually'])->name('invoice.mark-paid-manually');
    $router->post('invoices/{invoice}/payment/{payment}/confirm', [InvoiceController::class, 'confirmPayment'])->name('invoice.confirm-payment');
    $router->get('invoices/failed-payments', [InvoiceController::class, 'showFailed'])->name('failed_payments');
    $router->resource('invoices', InvoiceController::class);
});
