<?php

namespace Mtc\Checkout\Contracts;

use Mtc\Checkout\Invoice\Payment;

/**
 * Payment Gateway Interface
 *
 * This interface ensures payment gateways are swappable
 * and provide the minimal functionality required by the system
 *
 * @package  Mtc\Checkout
 */
interface HandlesRefunds
{
    /**
     * Check if payment is refundable by payment gateway
     *
     * @param Payment $payment
     * @return bool|array
     */
    public function isRefundable(Payment $payment);

    /**
     * Process a refund on payment
     *
     * @param Payment $payment
     * @param null|double $amount
     * @return bool|array
     */
    public function refund(Payment $payment, $amount = null);
}
