<?php

namespace Mtc\Checkout\Contracts;

use Mtc\Checkout\Invoice\Payment;

/**
 * Deferred Charges interface
 *
 * This interface ensures payment gateways allow deferred charges
 *
 * @package  Mtc\Checkout
 */
interface HasDeferredCharges
{
    /**
     * Check if payment can have a deferred charge
     *
     * @param Payment $payment
     * @return bool
     */
    public function allowDeferredCharge(Payment $payment);

    /**
     * Charge a payment that was set up as deferred
     *
     * @param Payment $payment
     * @return bool
     */
    public function chargeDeferredPayment(Payment $payment);
}
