<?php

namespace Mtc\Checkout\Contracts;

/**
 * Interface Payable
 *
 * @package Mtc\Checkout
 */
interface InvoiceRepositoryContract
{
    /**
     * Set model on repository
     *
     * @param $model
     * @return mixed
     */
    public function setModel($model);

    /**
     * Get the Record object for this invoice
     *
     * @return mixed
     */
    public function getPayable();

    /**
     * Get Invoice Id
     *
     * @return int
     */
    public function getId(): int;

    /**
     * Get Invoice Reference
     *
     * @return string
     */
    public function getReference(): string;

    /**
     * Get Invoice Model
     *
     * @return mixed
     */
    public function getModel();

    /**
     * Get Invoice assigned Member
     *
     * @return mixed
     */
    public function getMember();

    /**
     * Load invoice from Id
     *
     * @return void
     */
    public function load($id);

    /**
     * Return the outstanding payment amount
     *
     * @return float
     */
    public function getOutstandingAmount(): float;

    /**
     * Return the outstanding payment amount
     *
     * @return float
     */
    public function getOutstandingAmountInCurrency(): float;

    /**
     * Get the email address for the invoice recipient
     *
     * @return string
     */
    public function getEmail(): string;

    /**
     * Save the payment details for invoice
     *
     * @param $payment_details
     * @return mixed
     */
    public function savePayment($payment_details);

    /**
     * Reduce the outstanding amount from invoice
     *
     * @return void
     */
    public function reduceOutstandingAmount($amount);

    /**
     * Check if invoice has been paid or it has outstanding amount
     *
     * @return void
     */
    public function checkIfInvoiceIsPaid();

    /**
     * Get the currency for invoice
     *
     * @return string
     */
    public function getCurrency(): string;

    /**
     * Check if invoice has already been paid and processed
     *
     * @return bool
     */
    public function isPaid(): bool;

    /**
     * Invite invoice owner to pay for invoice
     *
     * @return bool
     */
    public function inviteToPay(): bool;

}
