<?php

namespace Mtc\Checkout\Contracts;

use Illuminate\Http\Request;
use Mtc\Checkout\PaymentForm;

/**
 * Payment Gateway Interface
 *
 * This interface ensures payment gateways are swappable
 * and provide the minimal functionality required by the system
 *
 * @package  Mtc\Checkout
 */
interface PaymentGateway
{
    /**
     * Check if the gateway is available for use on this payment.
     *
     * @param InvoiceRepositoryContract $invoice
     * @param PayableContract $payable
     * @return bool
     */
    public function isApplicable(InvoiceRepositoryContract $invoice, $payable): bool;

    /**
     * Render the payment template.
     *
     * @param InvoiceRepositoryContract $invoice
     * @param PayableContract $payable
     * @return string
     */
    public function getPaymentForm(InvoiceRepositoryContract $invoice): PaymentForm;

    /**
     * Charge payment on invoice
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @return array
     */
    public function charge(Request $request, InvoiceRepositoryContract $invoice): array;
}
