<?php

namespace Mtc\Checkout\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Checkout\Invoice;

/**
 * Class InvoiceSaved
 *
 * @package Mtc\Checkout
 */
class InvoiceSaved
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Invoice object
     *
     * @var Invoice
     */
    public $invoice;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Invoice $invoice)
    {
        $this->invoice = $invoice;
    }
}
