<?php

namespace Mtc\Checkout\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByCode
 *
 * @package Mtc\Checkout\Filters
 */
class FilterByUnpaidOrders implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'with_unpaid_orders';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'checkbox',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Include Unpaid Orders',
            'value' => \request(self::INPUT_FIELD_NAME),
            'field_value' => 1,
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if ($request->has(self::INPUT_FIELD_NAME)) {
            return $query;
        }

        return $query->where(function ($query) {
            return $query->where('payable_type', '!=', 'order')
                ->orWhereHas('order', function ($order_query) {
                    return $order_query->whereNotNull('paid_at');
                });
        });
    }
}
