<?php

namespace Mtc\Checkout\Invoice;

use Mtc\Checkout\Invoice;

/**
 * Class Address
 *
 * @package Mtc\Checkout\Invoice
 */
class Address extends \Mtc\Foundation\Address
{
    /**
     * Invoice address types
     */
    public const TYPE_RECIPIENT = 'recipient';
    public const TYPE_SELLER = 'seller';

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_addresses';

    /**
     * Relationship with the invoice
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
