<?php

return [
    'auto_load_migrations' => true,

    /*
    |--------------------------------------------------------------------------
    | Factory classes
    |--------------------------------------------------------------------------
    |
    | Factory classes are used to create related objects - e.g. creating order from
    | basket and then creating Invoice from order.
    |
    */
    'payable_factory' => \Mtc\Checkout\Factories\PayableFactory::class,
    'invoice_factory' => \Mtc\Checkout\Factories\InvoiceFactory::class,

    /*
    |--------------------------------------------------------------------------
    | Invoice repository
    |--------------------------------------------------------------------------
    |
    | Invoice repository is used to manage and manipulate invoice.
    | Having a repository decouples it from using a direct eloquent model.
    |
    */

    'invoice_repository' => \Mtc\Checkout\InvoiceRepository::class,

    /*
    |--------------------------------------------------------------------------
    | Customise checkout success/failure page data
    |--------------------------------------------------------------------------
    |
    | Response resources are used to pass data to payment success/failure pages
    |
    */

    'payment_response_handler' => \Mtc\Checkout\Http\Resources\PaymentResponse::class,

    /*
    |--------------------------------------------------------------------------
    | Service providers
    |--------------------------------------------------------------------------
    |
    | Checkout specific service providers added here
    |
    */

    'service_providers' => [
        \Mtc\Checkout\Providers\CheckoutRouteServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Multi currency payments
    |--------------------------------------------------------------------------
    |
    | Enabling this will allow payments to be taken in users set currency
    | if the payment gateway does support the functionality
    |
    */
    'multi_currency_payments' => false,

    /*
    |--------------------------------------------------------------------------
    | Deferred payments
    |--------------------------------------------------------------------------
    |
    | Enabling this will allow payments to be prepared during checkout stage
    | but not charged immediately (if payment gateway supports this).
    | Instead capturing payment will be done manually from admin
    |
    */

    'deferred_payments' => false,

    /*
    |--------------------------------------------------------------------------
    | Transaction Prefix
    |--------------------------------------------------------------------------
    |
    | Prefix transactions with a site-specific string
    |
    */

    'transaction_prefix' => '',
    'zero_amount_payment_reference_prefix' => '',

    /*
    |--------------------------------------------------------------------------
    | Payment page templates
    |--------------------------------------------------------------------------
    |
    | Customise over overwrite templates used by the checkout.
    | Use of constants allows changing the template on the fly.
    |
    */

    'payment_success_template' => 'checkout/success.twig',
    'payment_failure_template' => 'checkout/failed.twig',

    /*
    |--------------------------------------------------------------------------
    | Verification for user to view a paid invoice
    |--------------------------------------------------------------------------
    |
    | The class defined in this setting will be used to verify if user can view
    | success page for order if invoice has been paid and no longer has outstanding
    | amount.
    |
    */

    'verify_user_viewing_paid_order' => \Mtc\Checkout\PaidInvoiceViewVerification::class,

    /*
    |--------------------------------------------------------------------------
    | Multi-currency payments
    |--------------------------------------------------------------------------
    |
    | Enabling this allows users to place orders in the currency they currently have
    | as active. T
    |
    */

    'show_notice_about_payments_in_base_currency' => false,
    'allow_payments_in_selected_currency' => true,
];
