<?php

namespace Mtc\Checkout\Http\Resources;

use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Contracts\PaymentResponseContract;

/**
 * Class PaymentResponse
 *
 * @package Mtc\Checkout
 */
class PaymentResponse implements PaymentResponseContract
{
    /**
     * Render the success page
     *
     * @param InvoiceRepositoryContract $invoice
     * @return bool
     */
    public function success(InvoiceRepositoryContract $invoice, $events = []): string
    {
        return template(config('checkout.payment_success_template'), [
            'invoice' => $invoice,
            'tracking_scripts' => $events->pluck('tracking'),
            'page_meta' => [
                'title' => 'Your order is now complete | ' . config('app.name'),
                'page_title' => 'Order Complete',
                'page_sub_title' => 'Thank you for shopping online with ' . config('app.name'),
            ]
        ]);
    }

    /**
     * Render the failure page.
     *
     * @param InvoiceRepositoryContract $invoice
     * @return string
     */
    public function failure(InvoiceRepositoryContract $invoice): string
    {
        return template(config('checkout.payment_failure_template'), [
            'page_meta' => [
                'title' => 'Your order has not been processed | ' . config('app.name'),
                'page_title' => 'Order issue',
                'page_sub_title' => 'Your order has not been processed',
            ]
        ]);
    }
}
