<?php

namespace Mtc\Checkout\Contracts;

use Illuminate\Support\Collection;
use Mtc\Modules\Members\Classes\Member;

/**
 * Interface Payable
 *
 * @package Mtc\Checkout
 */
interface PayableContract
{
    /**
     * Fetch Attribute from payable
     *
     * @param $attribute
     * @return mixed
     */
    public function getAttribute($attribute);

    /**
     * Get the classname of payable to ensure we can link to it
     *
     * @return int
     */
    public function getPayableClass(): string;

    /**
     * Get the reference string
     *
     * @return string
     */
    public function getReference(): string;

    /**
     * Get the member assigned to this payable
     *
     * @return Member|null
     */
    public function getMember();

    /**
     * Get the invoice template used by the site for this payable
     *
     * @return string
     */
    public function getTemplate(): string;

    /**
     * Get the payment amount
     *
     * @return float
     */
    public function getAmount(): float;

    /**
     * Get the invoice items
     *
     * @return array
     */
    public function getItems(): Collection;

    /**
     * Get the additional lines for the invoice
     *
     * @return array
     */
    public function getLines(): array;

    /**
     * Get the billing address
     *
     * @return array
     */
    public function getAddress(): array;

    /**
     * Get the additional info that invoice should know about this payable
     *
     * @return mixed
     */
    public function getAdditionalDetails();

    /**
     * Check whether invoice should use inc vat or ex vat values
     *
     * @return bool
     */
    public function useExVat(): bool;
}
