# Checkout

This package provides payment handling on invoices functionality to [mtc platform](https://bitbucket.org/mtcmedia/platform).

Primary use case is within [mtcmedia/shop](https://bitbucket.org/mtcmedia/shop) to convert [basket](https://bitbucket.org/mtcmedia/packages-basket)
to [order](https://bitbucket.org/mtcmedia/packages-order-management/) by processing payment.

# Installation

`mtcmedia/checkout` is part of `mtcmedia/shop` so installation guide is applicable
only when attempting setup without this package. Outcome of this attempt might be
faulty due to potential dependencies on other shop packages.

Steps to install:

Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource
```bash
composer require mtcmedia/checkout
```
This adds package to vendor.
Next step is to run installation via

```bash
php artisan install:components
```
Installer will set up following steps:
- run migrations from package
- seed base data (e.g. menu entry)
- publish assets (vue components)
- install additional npm dependencies
- compile assets

# Configuration

Two config files are part of this system:

* `config/checkout.php` - defines the checkout process
* `config/invoices.php` - defines the invoice functionality

# Usage

This package allows simplified payment integration for traditional ecommerce baskets/orders as well as other types of payment flows. 

## Generating invoices

Key element of the checkout system is that payments are made against invoices. Other systems tend to use payment flow 
where payment is made directly against order or even basket, but this system introduces invoice generation flow.

For ecommerce the flow is `Basket` =(via `PayableFactory`)=> `Order` =(via `InvoiceFactory`)=> `Invoice`

Additional step of introducing Invoices is to allow implementation of more custom workflows:

* Deposit / part payment / final splits where purchase has multiple payments 
* Backorders where payment is made for the immediately paid products and backorder products can be charged when they are in stock


## Payment gateway flow

Key element of the system is to allow wide variety of payment gateways handling payments on invoices. 
To achieve this the given aspects have been implemented:

* Payment is made agaisnt invoice (not order) to ensure universal paid object
* `Mtc\Checkout\Contracts\PaymentGateway` and `Mtc\Checkout\Contracts\ExternalPaymentGateway` interfaces define actions payment gateway must comply with
* Additional payment flows are also defined as interfaces: `Mtc\Checkout\Contracts\HasDeferredCharges` and `Mtc\Checkout\Contracts\HandlesRefunds`

### PaymentGateway vs ExternalPaymentGateway

There are two interfaces that define how payment gateway should act - primary PaymentGateway and ExternalPaymentGateway.
PaymentGateway is linear flow where user proceeds to checkout page and fills out details (contact info/address etc).
ExternalPaymentGateway on the other hand processes express checkout workflows like PayPal Express Checkout, Apple Pay /Google Pay 
where customers use their devices to fill out basket details instead of relying on filling in checkout. 

### Registering payment gateways

To register a payment gateway following code must be invoked for each payment gateway within Service Provider boot method

```php
$this->app['payment']->extend('zero-amount-payment', function ($app) {
    return new ZeroAmountOrderPayment();
});
```

If payment gateway requires external JS libraries added to the checkout page, this should be done via 
`Mtc\Checkout\EventsAddPaymentGatewayScripts` event that will output returned content on the checkout page.
Similarly if external payment gateway is added, and it needs scripts on the page it should be done via 
`Mtc\Basket\Events\AddExternalPaymentGatewayScripts` event.

## Invoice actions

Invoice by itself is a standalone object and will have a number of possible actions.

**Marking as paid**

When payment is made against an invoice, outstanding amount is checked on invoice. If outstanding amount is 0 then invoice
is marked as paid and `Mtc\Checkout\Events\PaidInvoice` event is triggered. Ecommerce uses this event to then mark order as 
paid to handle the order processing flow (and then triggers `OrderPaid` event).

**Deferred invoice charge**

Some gateways allow for deferred payment flow. This flow authorizes a payment of the order but does not immediately capture it.
Capture has to be triggered manually from invoice management page (a button for doing this will be available on deferred payments). 
Gateways will have an expiry on how long an order can be authorized so long delays are likely to cause failures to capture.
Deferred payments are identified by having `null` for `confirmed_at`.

**Refunding payments**

Refunds are implemented via `mtcmedia/refunds` package, however the behaviour is defined by checkout. Each payment gateway
will specify whether it is capable of implementing refunds or not. If possible on invoice management page a form will appear
allowing to refund a payment. In most cases an input field will also exist to allow doing part-refunds. 

## Payment pages

For customers the package does provide only few payment pages - payment success and payment failed pages.

Payment success page will trigger `PaymentSuccessPage` event to allow adding additional elements like tracking scripts to the page.
This event also does have `$first_time` variable that specifies whether the page is loaded for the first time or has it been 
viewed already.
