<?php

namespace Mtc\Checkout\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Class PaidInvoice
 *
 * @package Mtc\Checkout
 */
class PaidInvoice
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Invoice object
     *
     * @var InvoiceRepositoryContract
     */
    public $invoice;

    /**
     * Payment reference
     *
     * @var string
     */
    public $reference;

    /**
     * Payment details
     *
     * @var array
     */
    public $payment_details;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(InvoiceRepositoryContract $invoice, string $reference, $payment_details = [])
    {
        $this->invoice = $invoice;
        $this->reference = $reference;
        $this->payment_details = $payment_details;
    }
}
