<?php

namespace Mtc\ChequePayment\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\ChequePayment\ChequePayment;

/**
 * Class ChequePaymentServiceProvider
 *
 * @package Mtc\BankTransfer
 */
class ChequePaymentServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('cheque.enabled', false) === false) {
            return;
        }

        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'cheque');
        $this->app['payment']->extend('cheque', function($app) {
            return new ChequePayment();
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/cheque.php' => config_path('cheque.php'),
            ], 'config');

            $this->publishes([
                \dirname(__DIR__, 2) . '/resources/templates' => public_path('templates'),
            ], 'templates');

        } else {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/cheque.php', 'cheque');

    }

}
