<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateContentEditorTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('content', function (Blueprint $table) {
            $table->id();
            $table->nullableMorphs('owner');
            $table->string('language', 10)->nullable()->index();
            $table->mediumText('content_structure')->nullable();
            $table->unsignedBigInteger('layout_id')->nullable()->index();
            $table->dateTime('layout_synced_at')->nullable()->index();
            $table->text('search_content')->nullable();
            $table->timestamps();
        });

        if (app()->runningUnitTests() === false) {
            DB::statement("ALTER TABLE `content` ADD FULLTEXT INDEX content_search_content_index (search_content)");
        }

        Schema::create('content_blocks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description', 500)->nullable();
            $table->string('category')->index();
            $table->boolean('should_be_repeated')->default(0);
            $table->text('fields');
            $table->timestamps();
        });

        Schema::create('content_layouts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->mediumText('layout')->nullable();
            $table->timestamps();
        });
        Schema::create('content_layout_blocks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('layout_id')->index();
            $table->unsignedBigInteger('block_id')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('content');
        Schema::dropIfExists('content_blocks');
        Schema::dropIfExists('content_layouts');
        Schema::dropIfExists('content_layout_blocks');
    }
}
