<?php

use Illuminate\Routing\Router;
use Mtc\ContentEditor\Http\Controllers\BlockController;
use Mtc\ContentEditor\Http\Controllers\ContentUIController;
use Mtc\ContentEditor\Http\Controllers\FormatController;
use Mtc\ContentEditor\Http\Controllers\LayoutController;

/** @var Router $router */
$router->group([
    'prefix' => config('admin.route_prefix'),
    'middleware' => [
        'auth'
    ]
], function (Router $router) {

    $router->group([
        'prefix' => 'content',
        'as' => 'content.'
    ], function (Router $router) {
        $router->get('blocks/all', [ BlockController::class , 'all' ])->name('blocks.all');

        $ui_routes = [
            'index',
            'create',
            'edit'
        ];

        $router->get('blocks', [ContentUIController::class, 'blocks'])->name('blocks.index');
        $router->get('blocks/create', [ContentUIController::class, 'createBlock'])->name('blocks.create');
        $router->get('blocks/{block}/edit', [ContentUIController::class, 'editBlock'])->name('blocks.edit');

        $router->get('blocks/list', [ BlockController::class, 'index'])->name('blocks.list');

        $router->resource('blocks', BlockController::class)->except($ui_routes);
        $router->resource('layouts', LayoutController::class)->except([ 'create', 'edit' ]);
    });
});
