<?php

namespace Mtc\ContentEditor;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Mtc\ContentEditor\Contracts\Block;
use Mtc\ContentEditor\Events\LoadContentBlockCategories;
use Mtc\Input\Fields;

class BlockRepository
{
    public function getList()
    {
        //
    }

    public function load()
    {
        //
    }

    public function save()
    {
        //
    }

    public function destroy()
    {
        //
    }

    public function groupByCategories(Collection $blocks): Collection
    {
        $block_categories = Config::get('content_editor.block_categories', []);
        return $blocks
            ->each(function (Block $model) {
                $model->fields = collect($model->fields)
                    ->map(function ($field) {
                        $field_object = Fields::fieldTypeObject($field['type']);
                        $field['ui_component'] = $field_object->uiComponent();
                        $field['choices'] = $field_object->displayChoices();
                        return $field;
                    });
            })
            ->groupBy('category')
            ->sortBy(function ($entry, $category) use ($block_categories) {
                return collect($block_categories)
                    ->where('id', $category)
                    ->map(function ($category, $index) {
                        return $index;
                    })->first();
            })
            ->keyBy(function ($entry, $category) use ($block_categories) {
                return collect($block_categories)
                        ->where('id', $category)
                        ->first()
                    ['name'] ?? $category;
            });
    }

    public function getCategories(): array
    {
        $event_categories = collect(Event::dispatch(LoadContentBlockCategories::class))
            ->filter();

        return collect(Config::get('content_editor.block_categories', []))
            ->merge($event_categories)
            ->sortBy(fn($category) => $category['order'] ?? 999)
            ->values()
            ->toArray();
    }
}
