<?php

namespace Mtc\ContentEditor;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Mtc\ContentEditor\Contracts\Block;
use Mtc\ContentEditor\Contracts\Content;
use Mtc\ContentEditor\Contracts\Layout;
use Mtc\ContentEditor\Seeds\ContentMenuSeeder;

class ContentProvider extends RouteServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/content_editor.php', 'content_editor');

        parent::register();
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'content');

        parent::boot();
        $this->app->bind(Content::class, Config::get('content_editor.content_model'));
        $this->app->bind(Block::class, Config::get('content_editor.block_model'));
        $this->app->bind(Layout::class, Config::get('content_editor.layout_model'));

        Event::listen('additional-database-seeds', function ($seeder) {
            $seeder->call(ContentMenuSeeder::class);
        });
    }

    public function map()
    {
        Route::middleware('web')->group(dirname(__DIR__) . '/routes/web.php');
    }
}
