<?php

namespace Mtc\ContentEditor\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Config;

abstract class Block extends Model
{
    protected $table = 'content_blocks';

    protected $fillable = [
        'name',
        'fields',
        'description',
        'category',
        'should_be_repeated',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'fields' => 'array',
    ];

    public function layouts(): BelongsToMany
    {
        return $this->belongsToMany(Config::get('content_editor.layout_model'), 'content_layout_blocks');
    }
}
