<?php

namespace Mtc\ContentEditor\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Config;

abstract class Layout extends Model
{
    protected $table = 'content_layouts';

    protected $fillable = [
        'name',
        'is_featured',
        'description',
    ];

    protected $casts = [
        'layout' => 'array',
    ];

    protected $hidden = [
         'created_at',
         'updated_at',
    ];

    public function blocks(): BelongsToMany
    {
        return $this->belongsToMany(Config::get('content_editor.block_model'), 'content_layout_blocks');
    }
}
