<?php

namespace Mtc\ContentEditor;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Support\Facades\Config;

/**
 * Trait HasContentFields
 * @package Mtc\ContentEditor
 * @property Model $content
 */
trait HasContentFields
{
    public static function bootHasContentFields()
    {
        // ??
    }

    public function allContents(): MorphMany
    {
        return $this->morphMany(Config::get('content_editor.content_model'), 'owner');
    }

    public function content($language = null): MorphOne
    {
        return $this->morphOne(Config::get('content_editor.content_model'), 'owner')
            ->where('language', $language);
    }

    public function saveContent($content, $layout = null, $language = null): Model
    {
        $content_fields = [
            'content_structure' => $content,
            'layout_id' => $layout,
            'search_content' => (new ContentFieldRepository())->buildSearchIndexForContent($content),
        ];
        return $this->content($language)
            ->updateOrCreate([], $content_fields);
    }

    public function setContent($content, $language = null): Model
    {
        $content_fields = [
            'content_structure' => $content,
            'search_content' => (new ContentFieldRepository())->buildSearchIndexForContent($content),
        ];
        return $this->content($language)
            ->updateOrCreate([], $content_fields);
    }

    public function getContent(): string|null
    {
        return $this->content?->content_structure;
    }

    public function getContentId(): int
    {
        return (int)$this->content?->id;
    }

    public function getLayout(): int
    {
        return (int)$this->content?->layout_id;
    }
}
