<?php

namespace Mtc\ContentEditor\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\ContentEditor\BlockRepository;
use Mtc\ContentEditor\Contracts\Block;
use Mtc\ContentEditor\Http\Requests\BlockRequest;
use Mtc\Input\Fields;

class BlockController
{
    use ValidatesRequests;

    /**
     * Display a listing of the resource.
     *
     * @return Collection
     */
    public function index(Request $request, Block $model)
    {
        return (new BlockRepository())->groupByCategories($model->newQuery()->get());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response|array
     */
    public function all(Block $block)
    {
        return [
            'blocks' => $block->newQuery()->get()
        ];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response|array
     */
    public function show(Block $content_block, $block_id, BlockRepository $block_repository)
    {
        $block = $content_block->newQuery()->find($block_id);

        return [
            'block' => $block,
            'categories' => $block_repository->getCategories(),
            'field_types' => Fields::allFieldTypes()
                ->map(function ($class_name) {
                    return App::make($class_name);
                })
        ];
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return Block
     */
    public function store(BlockRequest $request, Block $block)
    {
        $block = $block->newQuery()->findOrNew($request->input('id'));
        $block->fill($request->input());
        $block->save();
        return $block;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return void
     */
    public function destroy(Block $model, $id)
    {
        $block = $model->newQuery()->find($id);
        if ($block) {
            $block->delete();
        }
    }
}
