<?php

namespace Mtc\ContentEditor\Http\Controllers;

use Mtc\Breadcrumbs\Facades\Breadcrumbs;
use Mtc\ContentEditor\Contracts\Block;
use Mtc\ContentEditor\Contracts\Format;

class ContentUIController
{
    public function blocks()
    {
        Breadcrumbs::addCrumb('Content Blocks', route('content.blocks.index'));
        return view('content::blocks.index');
    }

    public function createBlock(Block $block)
    {
        Breadcrumbs::addCrumb('Content Blocks', route('content.blocks.index'));
        Breadcrumbs::addCrumb('Create Block', route('content.blocks.create'));
        return view('content::blocks.edit', compact('block'));
    }

    public function editBlock(Block $block)
    {
        Breadcrumbs::addCrumb('Content Blocks', route('content.blocks.index'));
        Breadcrumbs::addCrumb('Manage Block', route('content.blocks.edit', $block->id));
        return view('content::blocks.edit', compact('block'));
    }

    public function layouts()
    {
        return view('content::layouts.index');
    }
}
