<?php

namespace Mtc\ContentEditor\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Mtc\ContentEditor\Contracts\Content;
use Mtc\ContentEditor\Contracts\Layout;
use Mtc\ContentEditor\LayoutRepository;

class LayoutController
{
    use ValidatesRequests;

    public function index(Layout $layout)
    {
        return $layout->newQuery()->get();
    }

    public function store(Request $request, Layout $layout, LayoutRepository $layout_repository, Content $content)
    {
        $layout = $layout->newQuery()->findOrNew($request->input('id'));
        $this->validate($request, [
            'name' => 'required',
            'is_featured' => 'sometimes',
            'description' => 'sometimes',
            'layout' => 'required',
        ]);

        $layout->fill($request->input());
        $layout->layout = $layout_repository->contentToLayout($request->input('layout'));
        $layout->save();
        $layout_blocks = $layout_repository->extractBlockIds($request->input('layout'));
        $layout->blocks()->sync($layout_blocks);

        if ($request->has('attach_to_content')) {
            $content->newQuery()
                ->where('id', $request->input('attach_to_content'))
                ->update([
                    'layout_id' => $layout->id
                ]);
        }
        return $layout;
    }

    public function show(Layout $layout)
    {
        return $layout;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
