<?php

namespace Mtc\ContentEditor;

use Illuminate\Support\Collection;

class LayoutRepository
{
    public const LAYOUT_TYPES = [
        'list',
        'columns',
    ];

    public function contentToLayout(array $content_structure): array
    {
        return collect($content_structure)
            ->map(function ($block) {
                if (isset($block['type']) && in_array($block['type'], self::LAYOUT_TYPES)) {
                    $block['items'] = $this->contentToLayout($block['items']);
                } else {
                    $block['fields'] =  collect($block['fields'])->forget('value');
                }
                return $block;
            })
            ->toArray();
    }

    public function extractBlockIds(array $request_structure): array
    {
        return $this->recursiveExtractBlockIds($request_structure)
            ->flatten()
            ->unique()
            ->toArray();
    }

    protected function recursiveExtractBlockIds(array $request_structure): Collection
    {
        return collect($request_structure)
            ->map(function ($block) {
                if (isset($block['type']) && in_array($block['type'], self::LAYOUT_TYPES)) {
                    return $this->recursiveExtractBlockIds($block['items']);
                }
                return $block['block_id'];
            });
    }
}
