<?php

namespace Mtc\ContentEditor\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Admin\Facades\Navigation;
use Mtc\Admin\Models\Menu;

class ContentMenuSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $menu = Menu::query()
            ->where('permission_name', 'development-tools')
            ->first();
        if ($menu === null) {
            return;
        }

        collect(self::getData())
            ->each(function ($menu_entry) use ($menu) {

                $roles = $menu_entry['roles'] ?? [];
                unset($menu_entry['roles']);
                $child = $menu->children()->create($menu_entry);
                Navigation::grantMenuPermissionToRole($child, $roles);
            });
    }

    /**
     * Fetch the menu entries to seed
     *
     * @return array
     */
    protected static function getData()
    {
        return [
            [
                'title' => 'Content Blocks',
                'path' => '/content/blocks',
                'active_path' => '/content/blocks',
                'roles' => [
                    'Administrator'
                ],
            ],
        ];
    }
}
