<?php

namespace Tests\Unit;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Mtc\ContentEditor\BlockRepository;
use Mtc\ContentEditor\Models\Block;
use Tests\TestCase;

class BlockRepositoryTest extends TestCase
{
    use DatabaseMigrations;

    public function testGroupByCategoriesEmpty()
    {
        $grouped_data = (new BlockRepository())->groupByCategories(collect([]));

        self::assertEquals([], $grouped_data->toArray());
    }

    public function testGroupByCategoriesOne()
    {
        $block = Block::query()
            ->create([
                'name' => 'test',
                'fields' => [],
                'description' => '',
                'category' => 'content',
                'should_be_repeated' => false,
            ]);

        $test_data = [ $block ];

        $grouped_data = (new BlockRepository())->groupByCategories(collect($test_data));

        self::assertEquals([], $grouped_data->toArray());

    }

    public function testGroupByCategoriesMultiple()
    {

    }
}