<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Contracts\Support\Arrayable;

abstract class FormField implements Arrayable
{
    public const ICON = '';
    public const NAME = '';
    public const DESCRIPTION = '';
    public const COMPONENT = '';
    public const TYPE = '';
    public const FIELD_ID = '';
    public const NESTABLE = false;
    public const NESTED_LIMIT = null;
    public const EDITABLE = true;
    public const REPEATABLE = false;
    public const PREVIEW_IMAGE = null;

    protected static array $validationRules = [];

    public function toArray()
    {
        return [
            'icon' => static::ICON,
            'name' => static::NAME,
            'description' => static::DESCRIPTION,
            'component' => static::COMPONENT,
            'type' => static::TYPE,
            'fieldId' => static::FIELD_ID,
            'content' => '',
            'meta' => null,
            'nestable' => self::NESTABLE,
            'nestedLimit' => static::NESTED_LIMIT,
            'editable' => static::EDITABLE,
            'repeatable' => static::REPEATABLE,
            'previewImage' => static::PREVIEW_IMAGE,
        ];
    }

    public function getIcon(): string
    {
        return static::ICON;
    }

    public function getComponent(): string
    {
        return static::COMPONENT;
    }

    public function getValidationRules(string $prefix): array
    {
        return collect(static::$validationRules)
            ->keyBy(fn ($rules, $key) => $prefix . $key)
            ->toArray();
    }
}
