<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\ContentManager\Models\Content;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\PageStatus;

class PageContentFactory extends Factory
{
    protected $model = Content::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'page_id' => random_int(1, 100),
            'template_element_id' => random_int(0, 1) ? random_int(1, 100) : null,
            'parent_id' => random_int(0, 1) ? random_int(1, 100) : null,
            'global_content_id' => random_int(0, 1) ? random_int(1, 100) : null,
            'element_id' => random_int(0, 1) ? random_int(1, 100) : null,
            'slug' => $this->faker->slug(),
            'name' => $this->faker->word(),
            'content' => [],
            'data' => [],
            'order' => 0,
            'hidden' => 0,
        ];
    }
}
